/* version 0.6 ctemp.c May 25, 2005
 * very simple temperature converter written to fill in an
 * obvious gap in the typical linux command-line utilities.
 * Flags follow an in/out convention. For example celsius
 * in and kelvin out would be -ck. Fahrenheit is f, natch.
 */

#include <stdio.h>    /* for printf() */
#include <stdlib.h>   /* for atof() */
#include <ctype.h>    /* for isdigit() */
void noArgs();
void usage();
void oops();

main(int argc, char **argv)

{
    int i;
    char from = 'f';  /* f for fahrenheit */
    char to = 'c';    /* c for celsius or centigrade */

    if (argc == 1) { noArgs(); return 1; }
       /* program was invoked with no arguments */

    if ( argv[1][0] == '-' && argv[1][1] == '-' ) {
           usage(); return 0;
       }
       /* user input --help or some other unsupported long option */

    for (i=1; i < argc; ++i)    /* loop over argv */
    {
        /* examine argv to see if it's a flag */
        if ( argv[i][0] == '-' && !isdigit(argv[i][1]))
        {
            /* it's a flag, so we're changing from and to
             * if there's actually a temp to convert.
             * So, we'll check first */
            if ( argc == 2 ) { oops(); usage(); return 2; }
            from = argv[i][1];
            to = argv[i][2];
            continue;
        }
        /* Now we expect it's a number */

        if ( from == 'f' && to == 'c' ) {
            printf( "%.1f degrees celsius\n", 
                ( atof(argv[i]) - 32 ) / 1.8 );
        }
        else if ( from == 'f' && to == 'k' ) {
            printf( "%.2f degrees kelvin\n",
                (( atof(argv[i]) - 32) / 1.8) + 273.15 );
        }
        else if ( from == 'c' && to == 'f' ) {
            printf( "%.1f degrees fahrenheit\n", 
                ( atof(argv[i]) * 1.8 ) + 32 );
        }
        else if ( from == 'c' && to == 'k' ) {
            printf( "%.2f degrees kelvin\n", 
                atof(argv[i]) + 273.15 );
        }
        else if ( from == 'k' && to == 'f' ) {
            printf( "%.1f degrees fahrenheit\n", 
                (( atof(argv[i]) - 273.15) * 1.8 ) + 32 );
        }
        else if ( from == 'k' && to == 'c' ) {
            printf( "%.2f degrees celsius\n", 
                atof(argv[i]) - 273.15 );
        }
        /* if we got this far, almost certainly something is wrong
         * with the flags, so let's be nice and clue them in */
        else {
            printf("Getting here usually means an invalid flag.\n\n");
            usage();
        }
    }
    return 0;
}

void usage()
{
  printf("Usage:\n");
  printf("  Flags follow an in/out convention. For example celsius\n");
  printf("in and kelvin out would be -ck. Fahrenheit is f, natch.\n\n");

  printf("Make sure you use \"-\" as a flag prefix, and that your flags\n");
  printf("are correct. The program will simply ignore invalid flags.\n");
  printf("  Valid options are:\n");
  printf("no flag, -fc, -fk, -cf, -ck, -kf, -kc\n");
  printf("...where using no flag is equivalent to typing -fc. So\n");
  printf("  ctemp 32\n");
  printf("...will yield 0 degrees celsius, and is exactly the same as:\n");
  printf("  ctemp -fc 32\n");
  printf("Of course, the flag letters mean:\n");
  printf("  k -- kelvin\n");
  printf("  f -- fahrenheit\n");
  printf("  c -- celsius\n");
  printf("Note there is no relationship between the author and any\n");
  printf("fast-food chicken corporations.\n\n");

  printf("You can request any number of temperature conversions after\n"); 
  printf("the flag, and you can change the flag at any time. Subsequent\n");
  printf("conversions will always reflect the last flag. For example\n");
  printf("  ctemp 32 -cf 0 100 -ck 0\n");
  printf("Will yeild one celsius, two fahrenheit, and one kelvin result.\n\n");
} 

void noArgs()
   /* First I need to check for the Worst Case Scenario:
    * no flags or temperature input: the basic "run the
    * program with no arguments" error */
{
  printf("  Unfortunately, ctemp is not yet psychic. You should\n");
  printf("at least tell it what temperature you want to convert!\n\n");

  usage();
}

void oops()
  /* program invoked with flags but no temps */
{
  printf("Thanks for the flags, but ctemp is still hungry.\n"); 
  printf("  You must also feed it at least one temperature to convert.\n"); 
  printf("More is even better!\n\n");
} 
